TITLE   'Two Charged Metal Balls'					{ exa113.pde }
SELECT   						{ Professional Version }
   errlim=3e-5     ngrid=1     spectral_colors	
COORDINATES    ycylinder( 'r', 'z')
VARIABLES   U
DEFINITIONS
   r1=0.02     d0=0.1     r2=0.05     r3=1.0
   eps0=8.854e-12     eps=7*eps0		{ Glass }
   Q=1e-9     U2=40   				{ Voltage controlling charge }
   Er=-dr(U)     Ez=-dz(U)     E=-grad(U)     Em=magnitude(E)
   Der=eps*Er     Dez=eps*Ez     D=eps*E     Dm=magnitude(D)
   Up=Q/(4*pi*eps*sqrt(r^2+z^2))   		{ Potential of a point charge }
   Ep=-grad(Up)     Dp=eps*Ep 		{ For outer boundary }
   Q1=surf_integral( -normal(D), 'ball1')				{ Charge 1 }
   Q2=surf_integral( -normal(D), 'ball2')  				{ Charge 2 }
   F1=surf_integral( -0.5*normal(D)*Ez, 'ball1')			{  Force 1 }
   F2=surf_integral( -0.5*normal(D)*Ez, 'ball2')			{  Force 2 }
EQUATIONS
   div(D)=0						{ div( eps*( -grad( U))=0 }
BOUNDARIES
region 'dielectric' start (0,-d0/2-r1)  natural(U)=0  line to (0,-r3)
   natural(U)=normal(Dp) arc( center=0,0) angle=180 to (0,r3)
   natural(U)=0 line to (0,d0/2+r2)  value(U)=U2
   arc(center=0,d0/2) angle=-180				{ Ball2 }
   natural(U)=0  line to (0,-d0/2+r1) value(U)=0
   arc(center=0,-d0/2) angle=-180				{ Ball1 }
feature
   start 'outer' (0,-r3) arc( center=0,0) angle=180
   start 'ball1'  (0,-d0/2+r1) arc( center=0,-d0/2) angle=-180
   start 'ball2' (0,d0/2+r2) arc( center=0,d0/2) angle=-180
PLOTS
   contour( U)     vector( D) norm zoom(0,-1.5*d0, 3*d0,3*d0)
   contour( Dm) painted zoom(0,-1.5*d0, 3*d0,3*d0)		
   elevation( normal(D)) on 'outer'				{ ? Total charge }
summary				{ Numerical and textual plot page }
      report(Q1) report(Q2) report(Q1+Q2) report(F1)   report(F2)
      report(Q1*Q2/ [4*pi*eps*d0^2]) as 'Elementary estimate of F2'
END

